﻿/* Skript zur Demonstration von Unterabfragen in der WHERE-Klausel
 * Als Benutzer SCOTT ausführen
 */
 

-- Ausgangslage: Wie hoch ist das minimale Gehalt
select min(sal)
  from emp;
  
-- Wer verdient es?
select ename, job, sal
  from emp
 where sal = 800;
 
-- Wer verdient am wenigsten?
select ename, job, sal
  from emp
 where sal = (select min(sal)
                from emp);
                
-- Wer arbeitet in der gleichen Abteilung wie BLAKE? 
select ename, job, deptno
  from emp
 where deptno = (select deptno
                   from emp
                  where ename = 'BLAKE');
                
-- Wer hat den gleichen Beruf wie SCOTT? 
select ename, job, sal
  from emp
 where job = (select job
                from emp
               where ename = 'SCOTT');
                
-- Wer verdient mehr als MILLER? 
select ename, job, sal
  from emp
 where sal > (select sal
                from emp
               where ename = 'MILLER');
                
-- Wer wurde vor KING eingestellt?
select ename, job, hiredate
  from emp
 where hiredate < (select hiredate
                     from emp
                    where ename = 'KING');
                    
-- Wer verdient pro Abteilung am wenigsten?
select ename, job, sal, deptno
  from emp
 where sal in (select min(sal)
                 from emp
                group by deptno);
                
-- Verwendung der Funktion ANY
select ename, job, sal, deptno
  from emp
 where sal < any (select min(sal)
                    from emp
                   group by deptno)
 order by sal;

-- Umgeschriebene Variante der vorhergehenden Abfrage
select ename, job, sal, deptno
  from emp
 where sal < (select max(min(sal))
                from emp
               group by deptno)
 order by sal;

-- Unterabfrage mit mehreren Spalten
select ename, job, sal, deptno
  from emp
 where (deptno, sal) in
       (select deptno, min(sal)
          from emp
         group by deptno);
         
-- Gleiche Abfrage, andere Form: Dies gelingt nur zufällig
select ename, job, sal, deptno
  from emp
 where sal in (select min(sal)
                from emp
               group by deptno)
   and deptno in (select deptno
                    from emp)
 order by sal;
 
-- Unterschied zwischen paarwesem und nicht paarweisem Vergleich
-- Vorbereitung: Setze das Gehalt des Mitarbeiters ALLEN auf 1500 Taler
update emp
   set sal = 1250
 where ename = 'MILLER';

-- Rohdaten für die Abfrage:
select ename, job, sal, nvl(comm, 0)
  from emp;

-- Paarweiser Vergleich
select ename, job, sal
  from emp
 where (sal, comm) in
       (select sal, comm
          from emp
         where job = 'SALESMAN')
   and job != 'SALESMAN';
   
-- Nicht paarwweiser Vergleich:
select ename, job, sal
  from emp
 where sal in 
       (select sal
          from emp
         where job = 'SALESMAN')
   and nvl(comm, 0) in 
       (select comm
          from emp
         where job = 'SALESMAN')
   and job != 'SALESMAN';
   
rollback;

-- Harmonisierte Unterabfrage
select ename, deptno, job, sal
  from emp e
 where e.sal > (select avg(a.sal)
                  from emp a
                 where a.deptno = e.deptno);